/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWork;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.mapui.IVWTrackerStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMapAttribs;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class VWTrackerStepUI
implements IVWTrackerStepUI {
    private static DateFormat s_dateFormatter = DateFormat.getDateInstance(2);
    private static int s_hGap = 2;
    private static int s_vGap = 2;
    private Frame m_parentFrame = null;
    private VWBaseStepUI m_stepUI = null;
    private VWTrkStep m_step = null;
    private boolean m_bIsLaunchStep = false;
    private VWTrackerMapAttribs m_mapAttribs = null;
    private int m_occurrenceNum = -1;
    private String m_occurrenceNumString = null;
    private ImageIcon m_statusIcon = null;
    private ImageIcon m_lockIcon = null;
    private Date m_date = null;
    private String m_dateString = null;
    private Dimension m_runtimeInfoDim = null;
    private Dimension m_occurrenceDim = null;
    private Point m_offset = null;
    private boolean m_bUpdate = false;
    private Font m_font = null;
    private FontMetrics m_fm = null;
    private int m_fontHeight = 0;
    private int m_fontAscent = 0;
    private JPopupMenu m_popup = null;
    private JMenuItem m_miLock = null;
    private ActionListener m_miLockActionListener = null;
    private JMenuItem m_miUnlock = null;
    private ActionListener m_miUnlockActionListener = null;
    private ActionListener m_occActionListener = null;
    private Vector m_miOccurrences = null;

    public VWTrackerStepUI(Frame parentFrame, VWBaseStepUI stepUI, VWTrkStep step, boolean bLaunchStep, VWTrackerMapAttribs mapAttribs) {
        this.m_parentFrame = parentFrame;
        this.m_stepUI = stepUI;
        this.m_step = step;
        this.m_bIsLaunchStep = bLaunchStep;
        this.m_mapAttribs = mapAttribs;
        this.updateStepOccurrence();
    }

    public VWTrkStep getStepData() {
        return this.m_step;
    }

    public int getId() {
        return this.m_step.getStepId();
    }

    public String getName() {
        return this.m_step.getStepName();
    }

    public int getStepOccurrenceNum() {
        return this.m_occurrenceNum;
    }

    public void updateStepOccurrence() {
        int num = this.m_step.getSelectedOccurrenceIndex();
        VWTrkStepOccurrence occurrence = this.m_step.getSelectedOccurrence();
        if (occurrence != null) {
            this.m_occurrenceNum = num;
            this.m_occurrenceNumString = this.m_step.getOccurrenceCount() > 1 ? new Integer(this.m_occurrenceNum + 1).toString() : null;
            this.m_statusIcon = null;
            this.m_lockIcon = null;
            this.m_date = null;
            this.m_dateString = null;
            this.m_lockIcon = occurrence.getLockedStatusIcon();
            int status = occurrence.getStatus();
            this.m_statusIcon = VWImageLoader.createStatusIcon(status);
            switch (status) {
                case 2: 
                case 4: {
                    this.m_date = occurrence.getCompletionDate();
                    this.m_dateString = s_dateFormatter.format(this.m_date);
                }
            }
            this.m_bUpdate = true;
        }
    }

    public void updateLockStatusIcon() {
        if (this.m_occurrenceNum == -1) {
            return;
        }
        VWTrkStepOccurrence occurrence = this.m_step.getStepOccurrence(this.m_occurrenceNum);
        if (occurrence != null) {
            this.m_lockIcon = occurrence.getLockedStatusIcon();
            this.m_bUpdate = true;
        }
    }

    public void paintComponent(Graphics g) {
        if (!this.m_mapAttribs.isStepStatusVisible()) {
            return;
        }
        if (this.m_font == null) {
            Font font = g.getFont();
            this.m_font = new Font(font.getName(), font.getStyle(), font.getSize());
            this.m_fm = this.m_stepUI.getFontMetrics(this.m_font);
        }
        this.updateDimension(g);
        if (this.m_offset != null) {
            Rectangle imageRect = this.m_stepUI.getImageBounds();
            int x = this.m_offset.x + imageRect.x;
            int y = this.m_offset.y + imageRect.y;
            if (this.m_occurrenceDim != null) {
                g.drawString(this.m_occurrenceNumString, x + 1, y + this.m_fontAscent);
                g.draw3DRect(x, y, this.m_occurrenceDim.width + 2, this.m_occurrenceDim.height + 2, true);
                x += this.m_occurrenceDim.width + 2 + s_hGap;
            }
            if (this.m_lockIcon != null) {
                g.drawImage(this.m_lockIcon.getImage(), x, y, this.m_lockIcon.getIconWidth(), this.m_lockIcon.getIconHeight(), this.m_stepUI);
                x += this.m_lockIcon.getIconWidth() + s_hGap;
            }
            if (this.m_statusIcon != null) {
                g.drawImage(this.m_statusIcon.getImage(), x, y, this.m_statusIcon.getIconWidth(), this.m_statusIcon.getIconHeight(), this.m_stepUI);
                x += this.m_statusIcon.getIconWidth() + s_hGap;
            }
            if (this.m_dateString != null) {
                g.drawString(this.m_dateString, x, y + this.m_fontAscent);
            }
        }
    }

    public Rectangle getBounds(Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle(10, 10);
        }
        int loop = 0;
        do {
            if (this.m_runtimeInfoDim != null && this.m_offset != null) {
                Rectangle imageRect = this.m_stepUI.getImageBounds();
                Rectangle r = new Rectangle();
                int x = imageRect.x + this.m_offset.x;
                int y = imageRect.y + this.m_offset.y;
                int right = x + this.m_runtimeInfoDim.width;
                r.y = y;
                r.height = rect.height + this.m_runtimeInfoDim.height;
                r.x = x < rect.x ? x : rect.x;
                right = right > rect.x + rect.width ? right : rect.x + rect.width;
                r.width = right - r.x;
                rect = r;
            }
            ++loop;
            if (!this.m_bUpdate) break;
            this.updateDimension(null);
        } while (loop < 2);
        return rect;
    }

    public void createPopup(Container container, MouseEvent evt) {
        VWTrkStepOccurrence occurrence;
        Object source = evt.getSource();
        Point point = evt.getPoint();
        int occCount = this.m_step.getOccurrenceCount();
        boolean bLockable = false;
        boolean bUnlockable = false;
        if (this.m_step.getDataModel().isTracker() && (occurrence = this.m_step.getSelectedOccurrence()) != null && occurrence.isActive()) {
            int lockedStatus = occurrence.getLockedStatus();
            bLockable = (lockedStatus & 1) != 0;
            boolean bl = bUnlockable = (lockedStatus & 2) != 0;
        }
        if (occCount > 1 || bLockable || bUnlockable) {
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
            } else {
                this.m_popup.removeAll();
            }
            if (bLockable) {
                if (this.m_miLock == null) {
                    this.m_miLock = new JMenuItem(VWResource.s_lock);
                    this.m_miLockActionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                VWLockWork lockWork = new VWLockWork(VWTrackerStepUI.this.m_parentFrame, VWTrackerStepUI.this.m_step.getSelectedOccurrence());
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWTrackerStepUI.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_lock, 1, null);
                            }
                        }
                    };
                    this.m_miLock.addActionListener(this.m_miLockActionListener);
                }
                this.m_popup.add(this.m_miLock);
            }
            if (bUnlockable) {
                if (this.m_miUnlock == null) {
                    this.m_miUnlock = new JMenuItem(VWResource.s_unlock);
                    this.m_miUnlockActionListener = new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent e) {
                            VWUnlockWork unlockWork = null;
                            try {
                                unlockWork = new VWUnlockWork(VWTrackerStepUI.this.m_parentFrame, VWTrackerStepUI.this.m_step.getSelectedOccurrence());
                                if (unlockWork != null) {
                                    unlockWork.unlockWork();
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWTrackerStepUI.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
                            }
                            finally {
                                if (unlockWork != null) {
                                    unlockWork.removeReferences();
                                    unlockWork = null;
                                }
                            }
                        }
                    };
                    this.m_miUnlock.addActionListener(this.m_miUnlockActionListener);
                }
                this.m_popup.add(this.m_miUnlock);
            }
            if (occCount > 1) {
                if (bLockable || bUnlockable) {
                    this.m_popup.addSeparator();
                }
                if (this.m_occActionListener == null) {
                    this.m_occActionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            String cmd = e.getActionCommand();
                            int index = Integer.parseInt(cmd);
                            if (index > 0 && index <= VWTrackerStepUI.this.m_step.getOccurrenceCount()) {
                                VWTrackerStepUI.this.m_step.setSelectedOccurrenceIndex(index - 1);
                                VWTrackerStepUI.this.notifyPropertyChange();
                            }
                        }
                    };
                }
                if (this.m_miOccurrences == null) {
                    this.m_miOccurrences = new Vector();
                }
                JMenuItem mi = null;
                int count = this.m_miOccurrences.size();
                Vector occurrences = this.m_step.getOccurrenceCollection();
                VWTrkStepOccurrence occurrence2 = null;
                for (int i = 0; i < occCount; ++i) {
                    occurrence2 = (VWTrkStepOccurrence)occurrences.elementAt(i);
                    if (i >= count) {
                        mi = new JMenuItem(Integer.toString(i + 1));
                        mi.setActionCommand(Integer.toString(i + 1));
                        mi.addActionListener(this.m_occActionListener);
                        this.m_miOccurrences.add(mi);
                    } else {
                        mi = (JMenuItem)this.m_miOccurrences.elementAt(i);
                    }
                    if (occurrence2 != null) {
                        mi.setIcon(occurrence2.getStatusIcon());
                    }
                    this.m_popup.add(mi);
                }
            }
            this.m_popup.show(container, point.x, point.y);
        }
    }

    public void notifyPropertyChange() {
        VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 702));
    }

    public Vector getItemsChanged() {
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        steps.addElement(this.m_step);
        return steps;
    }

    private void updateDimension(Graphics g) {
        if (this.m_bUpdate) {
            int h;
            int w;
            int height = 0;
            int width = 0;
            FontMetrics fm = null;
            fm = g == null ? this.m_fm : g.getFontMetrics();
            if (fm == null) {
                return;
            }
            this.m_fontHeight = fm.getHeight();
            this.m_fontAscent = fm.getAscent();
            if (this.m_occurrenceNumString != null) {
                w = fm.stringWidth(this.m_occurrenceNumString) + 2;
                width += w;
                height = this.m_fontHeight + 2;
                this.m_occurrenceDim = new Dimension(w, this.m_fontHeight);
            }
            if (this.m_lockIcon != null) {
                h = this.m_lockIcon.getIconHeight();
                if (height < h) {
                    height = h;
                }
                width += this.m_lockIcon.getIconWidth() + s_hGap;
            }
            if (this.m_statusIcon != null) {
                h = this.m_statusIcon.getIconHeight();
                if (height < h) {
                    height = h;
                }
                width += this.m_statusIcon.getIconWidth() + s_hGap;
            }
            if (this.m_dateString != null && fm != null) {
                w = fm.stringWidth(this.m_dateString);
                width += w + s_hGap;
            }
            this.m_runtimeInfoDim = new Dimension(width, height += s_vGap);
            Rectangle imageRect = this.m_stepUI.getImageBounds();
            this.m_offset = new Point(0, 0);
            this.m_offset.x = (imageRect.width - this.m_runtimeInfoDim.width) / 2;
            this.m_offset.y = -this.m_runtimeInfoDim.height;
            this.m_bUpdate = false;
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_stepUI = null;
        this.m_step = null;
        this.m_occurrenceNumString = null;
        this.m_statusIcon = null;
        this.m_lockIcon = null;
        this.m_date = null;
        this.m_dateString = null;
        this.m_runtimeInfoDim = null;
        this.m_occurrenceDim = null;
        this.m_offset = null;
        this.m_font = null;
        this.m_fm = null;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miLock != null) {
            this.m_miLock.removeActionListener(this.m_miLockActionListener);
            this.m_miLock = null;
        }
        if (this.m_miUnlock != null) {
            this.m_miUnlock.removeActionListener(this.m_miUnlockActionListener);
            this.m_miUnlock = null;
        }
        if (this.m_miOccurrences != null) {
            for (int i = 0; i < this.m_miOccurrences.size(); ++i) {
                JMenuItem mi;
                Object obj = this.m_miOccurrences.elementAt(i);
                if (obj == null || !(obj instanceof JMenuItem) || (mi = (JMenuItem)obj) == null) continue;
                mi.removeActionListener(this.m_occActionListener);
            }
            this.m_occActionListener = null;
            this.m_miOccurrences.removeAllElements();
            this.m_miOccurrences = null;
        }
    }
}

